/*!
 * @file       BOARD_DP83848.h
 *
 * @brief      This file provides all the config DP83848 functions
 *
 * @version     V1.0.2
 *
 * @date        2022-06-23
 *
 * @attention
 *
 *  Copyright (C) 2021-2022 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be usefull and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

 /** jumpers setting
*    ==========================================================================================+
*      Jumper |       MII mode configuration            |      RMII mode configuration         +
*    ==========================================================================================+
*      JP3    | 2-3 provide 25MHz clock by MCO(PA8)     |  2-3 provide 25MHz clock by MCO(PA8) +
*             | 1-2 provide 25MHz clock by ext. Crystal |                                      +
*     -----------------------------------------------------------------------------------------+
*      JP2    |          2-3                            |  1-2                                 +
*     -----------------------------------------------------------------------------------------+
*      JP1    |          Open                           |  Close                               +
*    ==========================================================================================+
*/

/* Define to prevent recursive inclusion */
#ifndef __BOARD_DP83848_H
#define __BOARD_DP83848_H

#ifdef __cplusplus
  extern "C" {
#endif

/* Includes */

#include "apm32f4xx_eth.h"
#include "netif.h"

/** @addtogroup Examples
  @{
  */

/** @addtogroup ETH_Ping
  @{
  */

/** @defgroup ETH_Ping_Macros Macros
  @{
*/

/* DP83848_PHY_ADDRESS */
#define DP83848_PHY_ADDRESS       0x01



/* PHY USE MOC1 */
#define PHY_CLOCK_MCO

/**@} end of group ETH_Ping_Macros*/

/* MII and RMII mode selection */
#if defined (APM32F407_MINI)
#define RMII_MODE
#elif defined (APM32F407_ELE_HUETB)
#define MII_MODE
#else
#error "Please select first the APM32  board to be used (in board.h)"
#endif

/** @defgroup ETH_Ping_Macros Macros
  @{
*/

/* Reset delay */
#define DP83848_RESET_DELAY        PHY_RESET_DELAY

/**@} end of group ETH_Ping_Macros*/

/* define DP83848 GPIO */
#ifdef MII_MODE

/** @defgroup ETH_Ping_Macros Macros
  @{
*/

    /*
      ETH_MII_CRS                 PH2
      ETH_MII_RX_ER               PI10
      ETH_MII_COL                 PH3
      ETH_MII_RXD3                PH7
      ETH_MII_RXD2                PH6
      ETH_MII_TXD3                PB8
      ETH_MII_TXD2                PC2
      ETH_MII_TX_CLK              PC3
      ETH_MII_TX_EN               PG11
      ETH_MII_TXD0                PG13
      ETH_MII_TXD1                PG14
      ETH_MII_RXD1                PC5
      ETH_MII_RXD0                PC4
      ETH_MII_RX_DV               PA7
      ETH_MII_RX_CLK              PA1
    */
    /* ETH_MII_CRS PH2 */
    #define ETH_MII_CRS_GPIO_CLK           RCM_AHB1_PERIPH_GPIOH
    #define ETH_MII_CRS_PORT               GPIOH
    #define ETH_MII_CRS_PIN                GPIO_PIN_2
    #define ETH_MII_CRS_AF                 GPIO_AF_ETH
    #define ETH_MII_CRS_SOURCE             GPIO_PIN_SOURCE_2
    /* ETH_MII_RX_ER PI10 */
    #define ETH_MII_RX_ER_GPIO_CLK         RCM_AHB1_PERIPH_GPIOI
    #define ETH_MII_RX_ER_PORT             GPIOI
    #define ETH_MII_RX_ER_PIN              GPIO_PIN_10
    #define ETH_MII_RX_ER_AF               GPIO_AF_ETH
    #define ETH_MII_RX_ER_SOURCE           GPIO_PIN_SOURCE_10
    /* ETH_MII_COL PH3 */
    #define ETH_MII_COL_GPIO_CLK           RCM_AHB1_PERIPH_GPIOH
    #define ETH_MII_COL_PORT               GPIOH
    #define ETH_MII_COL_PIN                GPIO_PIN_3
    #define ETH_MII_COL_AF                 GPIO_AF_ETH
    #define ETH_MII_COL_SOURCE             GPIO_PIN_SOURCE_3
    /* ETH_MII_RXD3 PH7 */
    #define ETH_MII_RXD3_GPIO_CLK          RCM_AHB1_PERIPH_GPIOH
    #define ETH_MII_RXD3_PORT              GPIOH
    #define ETH_MII_RXD3_PIN               GPIO_PIN_7
    #define ETH_MII_RXD3_AF                GPIO_AF_ETH
    #define ETH_MII_RXD3_SOURCE            GPIO_PIN_SOURCE_7
    /* ETH_MII_RXD2 PH6 */
    #define ETH_MII_RXD2_GPIO_CLK          RCM_AHB1_PERIPH_GPIOH
    #define ETH_MII_RXD2_PORT              GPIOH
    #define ETH_MII_RXD2_PIN               GPIO_PIN_6
    #define ETH_MII_RXD2_AF                GPIO_AF_ETH
    #define ETH_MII_RXD2_SOURCE            GPIO_PIN_SOURCE_6
    /* ETH_MII_TXD3 PB8 */
    #define ETH_MII_TXD3_GPIO_CLK          RCM_AHB1_PERIPH_GPIOB
    #define ETH_MII_TXD3_PORT              GPIOB
    #define ETH_MII_TXD3_PIN               GPIO_PIN_8
    #define ETH_MII_TXD3_AF                GPIO_AF_ETH
    #define ETH_MII_TXD3_SOURCE            GPIO_PIN_SOURCE_8
    /* ETH_MII_TXD2 PC2 */
    #define ETH_MII_TXD2_GPIO_CLK          RCM_AHB1_PERIPH_GPIOC
    #define ETH_MII_TXD2_PORT              GPIOC
    #define ETH_MII_TXD2_PIN               GPIO_PIN_2
    #define ETH_MII_TXD2_AF                GPIO_AF_ETH
    #define ETH_MII_TXD2_SOURCE            GPIO_PIN_SOURCE_2
    /* ETH_MII_TX_CLK PC3 */
    #define ETH_MII_TX_CLK_GPIO_CLK        RCM_AHB1_PERIPH_GPIOC
    #define ETH_MII_TX_CLK_PORT            GPIOC
    #define ETH_MII_TX_CLK_PIN             GPIO_PIN_3
    #define ETH_MII_TX_CLK_AF              GPIO_AF_ETH
    #define ETH_MII_TX_CLK_SOURCE          GPIO_PIN_SOURCE_3
    /* ETH_MII_TX_EN PG11 */
    #define ETH_MII_TX_EN_GPIO_CLK         RCM_AHB1_PERIPH_GPIOG
    #define ETH_MII_TX_EN_PORT             GPIOG
    #define ETH_MII_TX_EN_PIN              GPIO_PIN_11
    #define ETH_MII_TX_EN_AF               GPIO_AF_ETH
    #define ETH_MII_TX_EN_SOURCE           GPIO_PIN_SOURCE_11
    /* ETH_MII_TXD0 PG13 */
    #define ETH_MII_TXD0_GPIO_CLK          RCM_AHB1_PERIPH_GPIOG
    #define ETH_MII_TXD0_PORT              GPIOG
    #define ETH_MII_TXD0_PIN               GPIO_PIN_13
    #define ETH_MII_TXD0_AF                GPIO_AF_ETH
    #define ETH_MII_TXD0_SOURCE            GPIO_PIN_SOURCE_13
    /* ETH_MII_TXD1 PG14 */
    #define ETH_MII_TXD1_GPIO_CLK          RCM_AHB1_PERIPH_GPIOG
    #define ETH_MII_TXD1_PORT              GPIOG
    #define ETH_MII_TXD1_PIN               GPIO_PIN_14
    #define ETH_MII_TXD1_AF                GPIO_AF_ETH
    #define ETH_MII_TXD1_SOURCE            GPIO_PIN_SOURCE_14
    /* ETH_MII_RXD1 PC5 */
    #define ETH_MII_RXD1_GPIO_CLK          RCM_AHB1_PERIPH_GPIOC
    #define ETH_MII_RXD1_PORT              GPIOC
    #define ETH_MII_RXD1_PIN               GPIO_PIN_5
    #define ETH_MII_RXD1_AF                GPIO_AF_ETH
    #define ETH_MII_RXD1_SOURCE            GPIO_PIN_SOURCE_5
    /* ETH_MII_RXD0 PC4 */
    #define ETH_MII_RXD0_GPIO_CLK          RCM_AHB1_PERIPH_GPIOC
    #define ETH_MII_RXD0_PORT              GPIOC
    #define ETH_MII_RXD0_PIN               GPIO_PIN_4
    #define ETH_MII_RXD0_AF                GPIO_AF_ETH
    #define ETH_MII_RXD0_SOURCE            GPIO_PIN_SOURCE_4
    /* ETH_MII_RX_DV PA7 */
    #define ETH_MII_RX_DV_GPIO_CLK         RCM_AHB1_PERIPH_GPIOA
    #define ETH_MII_RX_DV_PORT             GPIOA
    #define ETH_MII_RX_DV_PIN              GPIO_PIN_7
    #define ETH_MII_RX_DV_AF               GPIO_AF_ETH
    #define ETH_MII_RX_DV_SOURCE           GPIO_PIN_SOURCE_7
    /* ETH_MII_RX_CLK PA1 */
    #define ETH_MII_RX_CLK_GPIO_CLK        RCM_AHB1_PERIPH_GPIOA
    #define ETH_MII_RX_CLK_PORT            GPIOA
    #define ETH_MII_RX_CLK_PIN             GPIO_PIN_1
    #define ETH_MII_RX_CLK_AF              GPIO_AF_ETH
    #define ETH_MII_RX_CLK_SOURCE          GPIO_PIN_SOURCE_1

/**@} end of group ETH_Ping_Macros*/

#elif defined RMII_MODE

/** @defgroup ETH_Ping_Macros Macros
  @{
*/

     /*  
       ETH_RMII_REF_CLK    PA1
       ETH_RMII_CRS_DV     PA7
       ETH_RMII_RXD0       PC4
       ETH_RMII_RXD1       PC5
       ETH_RMII_TX_EN      PG11
       ETH_RMII_TXD0       PG13
       ETH_RMII_TXD1       PG14
    */
    /* ETH_RMII_REF_CLK PA1 */

    #define ETH_RMII_REF_CLK_GPIO_CLK     RCM_AHB1_PERIPH_GPIOA
    #define ETH_RMII_REF_CLK_PORT         GPIOA
    #define ETH_RMII_REF_CLK_PIN          GPIO_PIN_1
    #define ETH_RMII_REF_CLK_AF           GPIO_AF_ETH
    #define ETH_RMII_REF_CLK_SOURCE       GPIO_PIN_SOURCE_1
    /* ETH_RMII_CRS_DV     PA7 */
    #define ETH_RMII_CRS_DV_GPIO_CLK        RCM_AHB1_PERIPH_GPIOA
    #define ETH_RMII_CRS_DV_PORT            GPIOA
    #define ETH_RMII_CRS_DV_PIN             GPIO_PIN_7
    #define ETH_RMII_CRS_DV_AF              GPIO_AF_ETH
    #define ETH_RMII_CRS_DV_SOURCE          GPIO_PIN_SOURCE_7
    /* ETH_RMII_RXD0 PC4 */
    #define ETH_RMII_RXD0_GPIO_CLK        RCM_AHB1_PERIPH_GPIOC
    #define ETH_RMII_RXD0_PORT            GPIOC
    #define ETH_RMII_RXD0_PIN             GPIO_PIN_4
    #define ETH_RMII_RXD0_AF              GPIO_AF_ETH
    #define ETH_RMII_RXD0_SOURCE          GPIO_PIN_SOURCE_4
    /* ETH_RMII_RXD1 PC5 */
    #define ETH_RMII_RXD1_GPIO_CLK        RCM_AHB1_PERIPH_GPIOC
    #define ETH_RMII_RXD1_PORT            GPIOC
    #define ETH_RMII_RXD1_PIN             GPIO_PIN_5
    #define ETH_RMII_RXD1_AF              GPIO_AF_ETH
    #define ETH_RMII_RXD1_SOURCE          GPIO_PIN_SOURCE_5
    /* ETH_RMII_TX_EN PG11 */
    #define ETH_RMII_TX_EN_GPIO_CLK       RCM_AHB1_PERIPH_GPIOG
    #define ETH_RMII_TX_EN_PORT           GPIOG
    #define ETH_RMII_TX_EN_PIN            GPIO_PIN_11
    #define ETH_RMII_TX_EN_AF             GPIO_AF_ETH
    #define ETH_RMII_TX_EN_SOURCE         GPIO_PIN_SOURCE_11
    /* ETH_RMII_TXD0 PG13 */
    #define ETH_RMII_TXD0_GPIO_CLK        RCM_AHB1_PERIPH_GPIOG
    #define ETH_RMII_TXD0_PORT            GPIOG
    #define ETH_RMII_TXD0_PIN             GPIO_PIN_13
    #define ETH_RMII_TXD0_AF              GPIO_AF_ETH
    #define ETH_RMII_TXD0_SOURCE          GPIO_PIN_SOURCE_13
    /* ETH_RMII_TXD1 PG14 */
    #define ETH_RMII_TXD1_GPIO_CLK        RCM_AHB1_PERIPH_GPIOG
    #define ETH_RMII_TXD1_PORT            GPIOG
    #define ETH_RMII_TXD1_PIN             GPIO_PIN_14
    #define ETH_RMII_TXD1_AF              GPIO_AF_ETH
    #define ETH_RMII_TXD1_SOURCE          GPIO_PIN_SOURCE_14
    
/**@} end of group ETH_Ping_Macros*/

#endif

/** @defgroup ETH_Ping_Macros Macros
  @{
*/

/*
  ETH_RESET#                          PB15
  ETH_INT                             PB14
  ETH_MDIO                            PA2
  ETH_MDC                             PC1
  ETH_MCO                             PA8
*/

/* ETH_RESET# PB15 */
#define ETH_RESET_GPIO_CLK         RCM_AHB1_PERIPH_GPIOB
#define ETH_RESET_PORT             GPIOB
#define ETH_RESET_PIN              GPIO_PIN_15
#define ETH_RESET_PIN_HIGH()       GPIO_SetBit(ETH_RESET_PORT,ETH_RESET_PIN)
#define ETH_RESET_PIN_LOW()        GPIO_ResetBit(ETH_RESET_PORT,ETH_RESET_PIN)
/* ETH_INT PB14 */
#define ETH_INT_GPIO_CLK           RCM_AHB1_PERIPH_GPIOB
#define ETH_INT_PORT               GPIOB
#define ETH_INT_PIN                GPIO_PIN_14
#define ETH_INT_PIN_HIGH()         GPIO_SetBit(ETH_INT_PORT,ETH_INT_PIN)
#define ETH_INT_PIN_LOW()          GPIO_ResetBit(ETH_INT_PORT,ETH_INT_PIN)
 /* ETH_MII_MDC PC1 */
#define ETH_MDC_GPIO_CLK           RCM_AHB1_PERIPH_GPIOC
#define ETH_MDC_PORT               GPIOC
#define ETH_MDC_PIN                GPIO_PIN_1
#define ETH_MDC_AF                 GPIO_AF_ETH
#define ETH_MDC_SOURCE             GPIO_PIN_SOURCE_1
/* ETH_MII_MDIO PA2 */
#define ETH_MDIO_GPIO_CLK          RCM_AHB1_PERIPH_GPIOA
#define ETH_MDIO_PORT              GPIOA
#define ETH_MDIO_PIN               GPIO_PIN_2
#define ETH_MDIO_AF                GPIO_AF_ETH
#define ETH_MDIO_SOURCE            GPIO_PIN_SOURCE_2
/* ETH_MCO PA8 */
#define ETH_MCO_GPIO_CLK           RCM_AHB1_PERIPH_GPIOA
#define ETH_MCO_PORT               GPIOA
#define ETH_MCO_PIN                GPIO_PIN_8
#define ETH_MCO_AF                 GPIO_AF_MCO
#define ETH_MCO_SOURCE             GPIO_PIN_SOURCE_8

/**@} end of group ETH_Ping_Macros*/



/** @defgroup ETH_Ping_Functions Functions
  @{
*/

void  ConfigEthernet(void);

#ifdef __cplusplus
}
#endif

#endif /** __BOARD_DP83848_H */

/**@} end of group ETH_Ping_Functions */
/**@} end of group ETH_Ping */
/**@} end of group Examples */
